/******************************************************************************/
class MathHelper
{
public:
   
   // Checks if 2 vectors are equal. 'eps' = Epsilon; it's not possible to check if floating-point values are equal, so we check if they are more or less equal with the 'eps' as an "error-margin"
   // The smaller 'eps', the closer the 2 vectors will have to be before they are considered equal. If eps is too small, it might never return true.
   // E.G. Check if a moving object reached a position, might never be true if eps is too small (if you have a low FPS, the object will move less precise)
   static bool VectorsApproxEqual(Vec a, Vec b, flt eps)
   {
      return (FloatApproxEqual(a.x, b.x, eps) && 
              FloatApproxEqual(a.y, b.y, eps) && 
              FloatApproxEqual(a.z, b.z, eps));
   }
   
   // Check if 2 floating point values are equal. 'eps' = Epsilon.
   static bool FloatApproxEqual(float a, float b, flt eps)
   {
      if(a + eps > b && a - eps < b)
         return true;
      
      return false;
   }
}
/******************************************************************************/